 ; Pid: add a prefix and/or suffix to a text string or attdef.
 ; Copyright 1991, 2003 by Rocket Software Ltd.
 ; A single space is interpreted as an empty string - as in conversation.
 (DEFUN C:PID ( / ss lln num typ nnn zz cc ppref psuff)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (if (and pref suff) 
      (progn
           (write-line "Pick text or Return to edit pre/suffix: ")
           (setq ss (ssget '((-4 . "<or")
                             (0 . "text")
                             (0 . "attdef") (-4 . "or>"))))
           (setq num 0)
           (while (and ss (setq lln (ssname ss num)))
                  (setq num (1+ num))
                  (setq typ (cdr (assoc 0 (setq nnn (entget lln)))))
                  (cond ((= "TEXT" typ)
                         (setq zz (cdr (assoc 1 nnn)))
                         (setq cc (strcat pref zz suff))
                         (entmod (subst (cons 1 cc) (cons 1 zz) nnn)))
                        ((= "ATTDEF" typ)
                         (setq zz (cdr (assoc 2 nnn)))
                         (setq cc (strcat pref zz suff))
                         (entmod (subst (cons 2 cc) (cons 2 zz) nnn)))))))
  (if (null ss)
      (progn
           (if (= (type pref) 'STR)
               (progn
                    (setq ppref (getstring t (strcat "\nPrefix <" pref ">: ")))
                    (if (/= ppref "") (setq pref ppref)))
               (setq pref (getstring t "Prefix: ")))
           (if (= pref " ") (setq pref ""))
           (if (= (type suff) 'STR)
               (progn
                    (setq psuff (getstring t (strcat "\nSuffix <" suff ">: ")))
                    (if (/= psuff "") (setq suff psuff)))
               (setq suff (getstring t "Suffix: ")))
           (if (= suff " ") (setq suff ""))))
 (princ))